#version 330
#extension GL_EXT_gpu_shader4 : enable
//Colored Chain 3DMod01.fsh  by  Kamoshika
//https://www.shadertoy.com/view/wltBWr
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec3 hsv2rgb(float h, float s, float v) {
    vec3 res = fract(h+vec3(0,2,1)/3.);
    res = abs(res*6.-3.)-1.;
    res = clamp(res, 0., 1.);
    res = (res-1.)*s+1.;
    res *= v;
    return res;
}

float exp2Fog(float dist, float density) {
    float s = dist * density;
    return exp(-s*s);
}

float sdTorus(vec3 p) {
    return length(vec2(length(p.zx) - 0.3, p.y)) - 0.02;
}

// This also works.
// q = q.y > q.x ? q.yxz : q;
// q = q.y > q.z ? q.xzy : q;
// q = q.z > q.x ? q.zyx : q;
// float d = sdTorus(q - vec3(0.5, 0., 0.5));
// d = min(d, sdTorus(q.zxy - vec3(0., 0.5, 0.)));

float dist(vec3 p) {
    vec3 q = abs(fract(p) - 0.5);
    q = q.x > q.z ? q.zyx : q;
    if(q.y > 0.5 - q.x)q.xy = 0.5 - q.yx; // add
    if(q.y > 0.5 - q.z)q.yz = 0.5 - q.zy; // add
    float d = sdTorus(q);
    d = min(d, sdTorus(q.yxz + vec3(0, 0, -0.5)));
    //d = min(d, sdTorus(q + vec3(-0.5, -0.5, -0.5))); // no need
    //d = min(d, sdTorus(q.xzy + vec3(0, -0.5, -0.5))); // no need
    return d;
}

vec3 objColor(vec3 p) {
    vec3 col = vec3(0);
    vec3 q = abs(fract(p) - 0.5);
    float th = 0.01;
    float s = 0.8;
    float v = 1.;
    
    if(sdTorus(q) < th) {
        col = hsv2rgb(1./6., s, v);
    } else if(sdTorus(q + vec3(-0.5, -0.5, -0.5)) < th) {
        col = hsv2rgb(2./6., s, v);
    } else if(sdTorus(q.xzy + vec3(0, -0.5, -0.5)) < th) {
        col = hsv2rgb(3./6., s, v);
    } else if(sdTorus(q.yxz + vec3(0, 0, -0.5)) < th) {
        col = hsv2rgb(4./6., s, v);
    } else if(sdTorus(q.xzy + vec3(-0.5, 0, 0)) < th) {
        col = hsv2rgb(5./6., s, v);
    } else if(sdTorus(q.yxz + vec3(-0.5, -0.5, 0)) < th) {
        col = hsv2rgb(6./6., s, v);
    }
    
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
    vec2 p = (gl_FragCoord.xy*2.-iResolution.xy) / min(iResolution.x, iResolution.y);
    vec3 col = vec3(0);
    
    vec3 cPos = vec3(0., 0.5, 0.);
    cPos += vec3(-1, -1, -1)*fract(iTime*0.3);
    vec3 cDir = normalize(vec3(0.3, 0, -1.));
    vec3 up = vec3(0, 1, 0);
    vec3 cSide = normalize(cross(cDir, up));
    vec3 cUp = normalize(cross(cSide, cDir));
    
    vec3 ray = normalize(p.x*cSide + p.y*cUp + cDir*2.);
    
    vec3 rPos = cPos;
    float d = 0.;
    float count = 0.;
    for(int i=0; i<99; i++){
        d = dist(rPos);
        if(d < 0.0001){
            break;
        }
        rPos += ray * d;
        count++;
    }
    
    if(d < 0.1) {
        vec3 base = objColor(rPos);
        col = base * 20. / count;
    }
    
    float fog = exp2Fog(length(rPos-cPos), 0.1);
    col = mix(vec3(1), col, fog);
    
    gl_FragColor = vec4(col, 1.);
}
